<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Superelevation Cross Slope Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis příčného sklonu klopení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis příčného sklonu klopení</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="RoadwayDesigner">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@fileName"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není definováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Section Data -->
                                <xsl:for-each select="SuperelevationSections/SuperelevationSection">
                                    <table class="margin" cellpadding="3" width="90%">
                                        <tbody>
                                            <tr>
                                                <th align="left" lang="en" width = "15%">Název sekce:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" lang="en">Název základního směrového:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@baseHorizontal"/>
                                                </td>
                                            </tr>
                                            <xsl:if test="Standards">
                                                <tr>
                                                    <th align="left" lang="en">Název souboru směrnice:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@filename"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Návrhová rychlost:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@designSpeed"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Režim otáčení:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@pivotMethod"/>
                                                    </td>
                                                </tr>
                                                <xsl:if test="Standards/@normalCrossSlope">
                                                    <tr>
                                                        <th align="left" lang="en">Sklon střechy:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="cif:gradeFormat(number(Standards/@normalCrossSlope))"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@eSelection">
                                                    <tr>
                                                        <th align="left" lang="en">E výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@eSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@lSelection">
                                                    <tr>
                                                        <th align="left" lang="en">L výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@lSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                            </xsl:if>
                                        </tbody>
                                    </table>

                                    <xsl:for-each select="SuperelevationObjects/SuperelevationObject">
                                        <center>
                                            <p lang="en" style="font-weight:bold">
                                                <br/>Klopení:&#xa0; <xsl:value-of select="@name"/><br/>
                                            </p>
                                        </center>
                                        <table class="margin" cellpadding="3" cellspacing="2" width="95%">
                                            <thead style="display:table-header-group">
                                                <tr>
                                                    <th class="underline" lang="en" align="left">Staničení</th>
                                                    <th class="underline" lang="en" align="center">Šířka</th>
                                                    <th class="underline" lang="en" align="center">Klesání/Stoupání</th>
                                                    <th class="underline" lang="en" align="center">Příčný sklon</th>
                                                    <th class="underline" lang="en" align="center">ROC%</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <xsl:for-each select="SuperelevationTransitions/SuperelevationTransition">
                                                    <tr>
                                                        <td align="left">
                                                            <xsl:value-of select="cif:stationFormat(number(@externalStation), string(@externalStationName))"/>
                                                        </td>
                                                        <td align="center">
                                                            <xsl:value-of select="cif:distanceFormat(number(@width))"/>
                                                        </td>
                                                        <td align="center">
                                                            <xsl:value-of select="cif:ordinateFormat(number(@width) * number(@crossSlope))"/>
                                                        </td>
                                                        <td align="center">
                                                            <xsl:value-of select="cif:gradeFormat(number(@crossSlope))"/>
                                                        </td>
                                                        <xsl:if test="preceding-sibling::*">
                                                            <xsl:if test="not(@crossSlope = preceding-sibling::SuperelevationTransition[1]/@crossSlope) and not(@internalStation = preceding-sibling::SuperelevationTransition[1]/@internalStation)">
                                                                <td align="center">
                                                                    <xsl:value-of select='format-number((((number(@crossSlope) - number(preceding-sibling::SuperelevationTransition[1]/@crossSlope)) div (number(@internalStation) - number(preceding-sibling::SuperelevationTransition[1]/@internalStation))) * 100), "0.000")'/>
                                                                </td>
                                                            </xsl:if>
                                                        </xsl:if>
                                                    </tr>
                                                </xsl:for-each>
                                            </tbody>
                                        </table>
                                        <br/>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte nejdříve definovat klopení sekce.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu sekci klopení.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>